/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FspLockRecord {
    private int[] mLockAll;
    private long[] mResIds;
    private int[] mSegLen;
    private int mSegNum;
    private UnsignedInt32 mReqId;
    private int mLockType;
    private String mHmcId;
    private static final String GET_HMC_LOCK_STATUS_V3 = "GET_HMC_LOCK_STATUS_V3";
    private static final String SET_HMC_LOCKS_V2 = "SET_HMC_LOCKS_V2";
    private static final String RESET_HMC_LOCKS_V2 = "RESET_HMC_LOCKS_V2";
    private static final String DATA_OFFSET = "DATA_OFFSET";
    private static final String LOCK_NUM = "LOCK_NUM";
    private static final String LOCKS_REMAIN = "LOCKS_REMAIN";
    private static final String REC_SIZE = "REC_SIZE";
    private static final String LOCK_REC_LIST = "LOCK_REC_LIST";
    private static final String REQ_ID = "REQ_ID";
    private static final String FLAG = "FLAG";
    private static final String LOCK_RES = "LOCK_RES";
    private static final String HMC_ID_LEN = "HMC_ID_LEN";
    private static final String HMC_ID = "HMC_ID";
    private static int mIdCnt = 0;
    private static boolean mDisableFspLock = false;

    FspLockRecord() {
    }

    static FspLockRecord[] getHmcLockStatusCmd(FSPCmdMgr fSPCmdMgr, String string) throws PIHscServerException, PIHscCmdMgrException {
        if (mDisableFspLock) {
            return null;
        }
        Vector<FspLockRecord> vector = new Vector<FspLockRecord>();
        int n = 0;
        int[] nArray = new int[]{16384, 32768};
        int[] nArray2 = new int[]{2, 72};
        int n2 = string.length();
        if (n2 % 4 != 0) {
            n2 += 4 - n2 % 4 + 2;
            for (int i = string.length(); i < n2; ++i) {
                string = string + "\u0000";
            }
        }
        byte[] byArray = string.getBytes();
        int n3 = 1213023008;
        String string2 = ByteUtilities.toHexString(byArray);
        block3: for (int i = 0; i < 2; ++i) {
            int n4 = nArray2[i];
            while (true) {
                Hashtable hashtable;
                Object[] objectArray;
                if ((objectArray = (Object[])(hashtable = fSPCmdMgr.doFSPCommand(GET_HMC_LOCK_STATUS_V3, new String[]{"" + n, "" + n4, "" + nArray[i], "" + n3, "" + n2, string2})).get(LOCK_REC_LIST)) == null || objectArray.length == 0) {
                    if (objectArray == null) {
                        System.out.println("lock list is null");
                        continue block3;
                    }
                    System.out.println("lock list is empty");
                    continue block3;
                }
                System.out.println("lock list length is:" + objectArray.length);
                for (int j = 0; j < objectArray.length; ++j) {
                    try {
                        Hashtable hashtable2 = (Hashtable)objectArray[j];
                        System.out.println("rechash: " + hashtable2);
                        UnsignedInt32 unsignedInt32 = (UnsignedInt32)hashtable2.get(REQ_ID);
                        UnsignedInt32 unsignedInt322 = (UnsignedInt32)hashtable2.get(FLAG);
                        byte[] byArray2 = (byte[])hashtable2.get(LOCK_RES);
                        FspLockRecord fspLockRecord = FspLockRecord.createLockRecord(string, unsignedInt32, unsignedInt322.longValue(), byArray2);
                        System.out.println("lock record: " + fspLockRecord);
                        vector.addElement(fspLockRecord);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                n4 = ((UnsignedInt16)hashtable.get(LOCKS_REMAIN)).intValue();
                if (n4 == 0) continue block3;
                n += objectArray.length;
            }
        }
        FspLockRecord[] fspLockRecordArray = new FspLockRecord[vector.size()];
        return vector.toArray(fspLockRecordArray);
    }

    static UnsignedInt32 setHmcLockCmd(FSPCmdMgr fSPCmdMgr, int n, byte[] byArray) throws PIHscServerException, PIHscCmdMgrException {
        if (mDisableFspLock) {
            return new UnsignedInt32((long)mIdCnt++);
        }
        String string = ByteUtilities.toHexString(byArray);
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(SET_HMC_LOCKS_V2, new String[]{"8", "" + n, "16", string}, 180000);
        return (UnsignedInt32)hashtable.get(REQ_ID);
    }

    static void unlockAllCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        if (mDisableFspLock) {
            return;
        }
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String string = ByteUtilities.toHexString(byArray);
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(RESET_HMC_LOCKS_V2, new String[]{"0", "3", "0", "0", string});
    }

    static void unlockRecordsCmd(FSPCmdMgr fSPCmdMgr, int n, byte[] byArray) throws PIHscServerException, PIHscCmdMgrException {
        if (mDisableFspLock) {
            return;
        }
        String string = ByteUtilities.toHexString(byArray);
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(RESET_HMC_LOCKS_V2, new String[]{"8", "2", "" + n, "16", string});
    }

    private static FspLockRecord createLockRecord(String string, UnsignedInt32 unsignedInt32, long l, byte[] byArray) {
        FspLockRecord fspLockRecord = new FspLockRecord();
        fspLockRecord.mHmcId = string;
        fspLockRecord.mReqId = unsignedInt32;
        if (l == 0L) {
            return fspLockRecord;
        }
        fspLockRecord.mLockType = (int)(l >> 28 & 0xFL);
        fspLockRecord.mSegNum = (int)(l >> 24 & 0xFL);
        fspLockRecord.mLockAll = new int[fspLockRecord.mSegNum];
        fspLockRecord.mSegLen = new int[fspLockRecord.mSegNum];
        fspLockRecord.mResIds = new long[fspLockRecord.mSegNum];
        boolean bl = false;
        for (int i = 0; i < fspLockRecord.mSegNum; ++i) {
            int n = (int)(l >> 20 - i * 4 & 0xFL);
            fspLockRecord.mLockAll[i] = n >> 2 & 3;
            fspLockRecord.mSegLen[i] = (n & 3) + 1;
            fspLockRecord.mResIds[i] = 0L;
            for (int j = 0; j < fspLockRecord.mSegLen[i]; ++j) {
                fspLockRecord.mResIds[i] = (fspLockRecord.mResIds[i] << 8) + (long)(byArray[i] & 0xFF);
            }
        }
        return fspLockRecord;
    }

    public long[] getResIds() {
        return this.mResIds;
    }

    public UnsignedInt32 getReqId() {
        return this.mReqId;
    }

    public String getHmcId() {
        return this.mHmcId;
    }

    public String toString() {
        String string = "hmcId = " + this.mHmcId + "reqId = " + this.mReqId + " lockType = " + this.mLockType + " segNum = " + this.mSegNum + "\n";
        for (int i = 0; i < this.mSegNum; ++i) {
            string = string + "seg[" + i + "] len = " + this.mSegLen[i] + " lockAll = " + this.mLockAll[i] + " resId = 0x" + Long.toHexString(this.mResIds[i]) + "\n";
        }
        return string;
    }

    static {
        try {
            File file = new File("/opt/hsc/data/disablefsplock");
            if (file.exists()) {
                mDisableFspLock = true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

